#set_property IOSTANDARD LVCMOS33 [get_ports {decoded_ip[*]}]
#set_property IOSTANDARD LVCMOS33 [get_ports decoded_clk_ip]
#set_property IOSTANDARD LVCMOS33 [get_ports {gpio_op[*]}]
#set_property IOSTANDARD LVCMOS33 [get_ports sp_pwm_op]
set_property IOSTANDARD LVCMOS15 [get_ports {led_op[*]}]

set_property IOSTANDARD LVCMOS33 [get_ports xtalclk_ip]
set_property PACKAGE_PIN C12 [get_ports xtalclk_ip]
create_clock -name xtalclk_ip -period 20.0 [get_ports xtalclk_ip]
create_clock -name FX2_clkout -period 20.0 [get_ports FX2_clkout]

set_property IOSTANDARD LVCMOS33 [get_ports pushsw_ip]
set_property PACKAGE_PIN D11 [get_ports pushsw_ip]

#set_property PACKAGE_PIN J1 [get_ports {gpio_op[0]}]
#set_property PACKAGE_PIN J2 [get_ports {gpio_op[1]}]
#set_property PACKAGE_PIN K1 [get_ports {gpio_op[2]}]
#set_property PACKAGE_PIN L1 [get_ports {gpio_op[3]}]
#set_property PACKAGE_PIN M4 [get_ports sp_pwm_op]
set_property PACKAGE_PIN A5 [get_ports {led_op[0]}]
set_property PACKAGE_PIN J5 [get_ports {led_op[1]}]
set_property PACKAGE_PIN G5 [get_ports {led_op[2]}]
set_property PACKAGE_PIN B5 [get_ports {led_op[3]}]
set_property PACKAGE_PIN F5 [get_ports {led_op[4]}]
set_property PACKAGE_PIN E5 [get_ports {led_op[5]}]
set_property PACKAGE_PIN F6 [get_ports {led_op[6]}]
set_property PACKAGE_PIN E4 [get_ports {led_op[7]}]


set_property IOSTANDARD LVCMOS33 [get_ports FX2_clkout]
set_property PACKAGE_PIN V15 [get_ports FX2_clkout]
set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets FX2_clkout_IBUF]
set_property IOSTANDARD LVCMOS33 [get_ports {FX2_fd[*]}]
set_property PACKAGE_PIN R12 [get_ports {FX2_fd[0]}]
set_property PACKAGE_PIN N15 [get_ports {FX2_fd[1]}]
set_property PACKAGE_PIN N14 [get_ports {FX2_fd[2]}]
set_property PACKAGE_PIN M15 [get_ports {FX2_fd[3]}]
set_property PACKAGE_PIN M14 [get_ports {FX2_fd[4]}]
set_property PACKAGE_PIN L16 [get_ports {FX2_fd[5]}]
set_property PACKAGE_PIN L13 [get_ports {FX2_fd[6]}]
set_property PACKAGE_PIN L14 [get_ports {FX2_fd[7]}]
set_property PACKAGE_PIN R17 [get_ports {FX2_fd[8]}]
set_property PACKAGE_PIN T18 [get_ports {FX2_fd[9]}]
set_property PACKAGE_PIN U18 [get_ports {FX2_fd[10]}]
set_property PACKAGE_PIN U17 [get_ports {FX2_fd[11]}]
set_property PACKAGE_PIN V17 [get_ports {FX2_fd[12]}]
set_property PACKAGE_PIN U16 [get_ports {FX2_fd[13]}]
set_property PACKAGE_PIN V16 [get_ports {FX2_fd[14]}]
set_property PACKAGE_PIN U15 [get_ports {FX2_fd[15]}]
set_property IOSTANDARD LVCMOS33 [get_ports {FX2_fifoadr[*]}]
set_property PACKAGE_PIN N18 [get_ports {FX2_fifoadr[0]}]
set_property PACKAGE_PIN P18 [get_ports {FX2_fifoadr[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports FX2_flaga]
set_property PACKAGE_PIN L17 [get_ports FX2_flaga]
set_property IOSTANDARD LVCMOS33 [get_ports FX2_flagb]
set_property PACKAGE_PIN L18 [get_ports FX2_flagb]
set_property IOSTANDARD LVCMOS33 [get_ports FX2_flagc]
set_property PACKAGE_PIN M17 [get_ports FX2_flagc]
set_property IOSTANDARD LVCMOS33 [get_ports FX2_ifclk]
set_property PACKAGE_PIN R16 [get_ports FX2_ifclk]
set_property IOSTANDARD LVCMOS33 [get_ports FX2_pktend]
set_property PACKAGE_PIN R18 [get_ports FX2_pktend]
set_property IOSTANDARD LVCMOS33 [get_ports FX2_sloe]
set_property PACKAGE_PIN M18 [get_ports FX2_sloe]
set_property IOSTANDARD LVCMOS33 [get_ports FX2_slrd]
set_property PACKAGE_PIN T15 [get_ports FX2_slrd]
set_property IOSTANDARD LVCMOS33 [get_ports FX2_slwr]
set_property PACKAGE_PIN R15 [get_ports FX2_slwr]

#set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets {design_1_i/clk_wiz_0/inst/clk_in1_main_clk_wiz_0_0}]

#set_property BITSTREAM.CONFIG.CONFIGRATE 66 [current_design]
#set_property CONFIG_MODE SPIx2 [current_design]

#set_property IO_BUFFER_TYPE NONE [get_ports {ddr3_ck_n[*]} ]
#set_property IO_BUFFER_TYPE NONE [get_ports {ddr3_ck_p[*]} ]
#set_property SLEW FAST [get_ports {ddr3_dq[0]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dq[0]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dq[0]}]
#set_property PACKAGE_PIN H4 [get_ports {ddr3_dq[0]}]
#set_property SLEW FAST [get_ports {ddr3_dq[1]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dq[1]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dq[1]}]
#set_property PACKAGE_PIN H5 [get_ports {ddr3_dq[1]}]
#set_property SLEW FAST [get_ports {ddr3_dq[2]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dq[2]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dq[2]}]
#set_property PACKAGE_PIN H6 [get_ports {ddr3_dq[2]}]
#set_property SLEW FAST [get_ports {ddr3_dq[3]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dq[3]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dq[3]}]
#set_property PACKAGE_PIN H2 [get_ports {ddr3_dq[3]}]
#set_property SLEW FAST [get_ports {ddr3_dq[4]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dq[4]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dq[4]}]
#set_property PACKAGE_PIN H3 [get_ports {ddr3_dq[4]}]
#set_property SLEW FAST [get_ports {ddr3_dq[5]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dq[5]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dq[5]}]
#set_property PACKAGE_PIN J1 [get_ports {ddr3_dq[5]}]
#set_property SLEW FAST [get_ports {ddr3_dq[6]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dq[6]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dq[6]}]
#set_property PACKAGE_PIN G6 [get_ports {ddr3_dq[6]}]
#set_property SLEW FAST [get_ports {ddr3_dq[7]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dq[7]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dq[7]}]
#set_property PACKAGE_PIN J2 [get_ports {ddr3_dq[7]}]
#set_property SLEW FAST [get_ports {ddr3_addr[15]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[15]}]
#set_property PACKAGE_PIN A7 [get_ports {ddr3_addr[15]}]
#set_property SLEW FAST [get_ports {ddr3_addr[14]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[14]}]
#set_property PACKAGE_PIN A8 [get_ports {ddr3_addr[14]}]
#set_property SLEW FAST [get_ports {ddr3_addr[13]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[13]}]
#set_property PACKAGE_PIN A6 [get_ports {ddr3_addr[13]}]
#set_property SLEW FAST [get_ports {ddr3_addr[12]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[12]}]
#set_property PACKAGE_PIN B3 [get_ports {ddr3_addr[12]}]
#set_property SLEW FAST [get_ports {ddr3_addr[11]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[11]}]
#set_property PACKAGE_PIN A3 [get_ports {ddr3_addr[11]}]
#set_property SLEW FAST [get_ports {ddr3_addr[10]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[10]}]
#set_property PACKAGE_PIN C4 [get_ports {ddr3_addr[10]}]
#set_property SLEW FAST [get_ports {ddr3_addr[9]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[9]}]
#set_property PACKAGE_PIN E3 [get_ports {ddr3_addr[9]}]
#set_property SLEW FAST [get_ports {ddr3_addr[8]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[8]}]
#set_property PACKAGE_PIN B7 [get_ports {ddr3_addr[8]}]
#set_property SLEW FAST [get_ports {ddr3_addr[7]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[7]}]
#set_property PACKAGE_PIN F4 [get_ports {ddr3_addr[7]}]
#set_property SLEW FAST [get_ports {ddr3_addr[6]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[6]}]
#set_property PACKAGE_PIN D6 [get_ports {ddr3_addr[6]}]
#set_property SLEW FAST [get_ports {ddr3_addr[5]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[5]}]
#set_property PACKAGE_PIN A2 [get_ports {ddr3_addr[5]}]
#set_property SLEW FAST [get_ports {ddr3_addr[4]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[4]}]
#set_property PACKAGE_PIN A4 [get_ports {ddr3_addr[4]}]
#set_property SLEW FAST [get_ports {ddr3_addr[3]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[3]}]
#set_property PACKAGE_PIN B1 [get_ports {ddr3_addr[3]}]
#set_property SLEW FAST [get_ports {ddr3_addr[2]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[2]}]
#set_property PACKAGE_PIN C1 [get_ports {ddr3_addr[2]}]
#set_property SLEW FAST [get_ports {ddr3_addr[1]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[1]}]
#set_property PACKAGE_PIN B4 [get_ports {ddr3_addr[1]}]
#set_property SLEW FAST [get_ports {ddr3_addr[0]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_addr[0]}]
#set_property PACKAGE_PIN D1 [get_ports {ddr3_addr[0]}]
#set_property SLEW FAST [get_ports {ddr3_ba[2]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_ba[2]}]
#set_property PACKAGE_PIN D2 [get_ports {ddr3_ba[2]}]
#set_property SLEW FAST [get_ports {ddr3_ba[1]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_ba[1]}]
#set_property PACKAGE_PIN E6 [get_ports {ddr3_ba[1]}]
#set_property SLEW FAST [get_ports {ddr3_ba[0]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_ba[0]}]
#set_property PACKAGE_PIN B2 [get_ports {ddr3_ba[0]}]
#set_property SLEW FAST [get_ports {ddr3_ras_n}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_ras_n}]
#set_property PACKAGE_PIN F2 [get_ports {ddr3_ras_n}]
#set_property SLEW FAST [get_ports {ddr3_cas_n}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_cas_n}]
#set_property PACKAGE_PIN F1 [get_ports {ddr3_cas_n}]
#set_property SLEW FAST [get_ports {ddr3_we_n}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_we_n}]
#set_property PACKAGE_PIN E2 [get_ports {ddr3_we_n}]
#set_property SLEW FAST [get_ports {ddr3_reset_n}]
#set_property IOSTANDARD LVCMOS15 [get_ports {ddr3_reset_n}]
#set_property PACKAGE_PIN F3 [get_ports {ddr3_reset_n}]
#set_property SLEW FAST [get_ports {ddr3_cke[0]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_cke[0]}]
#set_property PACKAGE_PIN C3 [get_ports {ddr3_cke[0]}]
#set_property SLEW FAST [get_ports {ddr3_odt[0]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_odt[0]}]
#set_property PACKAGE_PIN E1 [get_ports {ddr3_odt[0]}]
#set_property SLEW FAST [get_ports {ddr3_cs_n[0]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_cs_n[0]}]
#set_property PACKAGE_PIN C2 [get_ports {ddr3_cs_n[0]}]
#set_property SLEW FAST [get_ports {ddr3_dm[0]}]
#set_property IOSTANDARD SSTL15 [get_ports {ddr3_dm[0]}]
#set_property PACKAGE_PIN J4 [get_ports {ddr3_dm[0]}]
#set_property SLEW FAST [get_ports {ddr3_dqs_p[0]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dqs_p[0]}]
#set_property IOSTANDARD DIFF_SSTL15 [get_ports {ddr3_dqs_p[0]}]
#set_property PACKAGE_PIN G2 [get_ports {ddr3_dqs_p[0]}]
#set_property SLEW FAST [get_ports {ddr3_dqs_n[0]}]
#set_property IN_TERM UNTUNED_SPLIT_50 [get_ports {ddr3_dqs_n[0]}]
#set_property IOSTANDARD DIFF_SSTL15 [get_ports {ddr3_dqs_n[0]}]
#set_property PACKAGE_PIN G1 [get_ports {ddr3_dqs_n[0]}]
#set_property SLEW FAST [get_ports {ddr3_ck_p[0]}]
#set_property IOSTANDARD DIFF_SSTL15 [get_ports {ddr3_ck_p[0]}]
#set_property PACKAGE_PIN D7 [get_ports {ddr3_ck_p[0]}]
#set_property SLEW FAST [get_ports {ddr3_ck_n[0]}]
#set_property IOSTANDARD DIFF_SSTL15 [get_ports {ddr3_ck_n[0]}]
#set_property PACKAGE_PIN C7 [get_ports {ddr3_ck_n[0]}]
#set_property LOC PHASER_OUT_PHY_X1Y7 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_D.ddr_byte_lane_D/phaser_out}]
#set_property LOC PHASER_OUT_PHY_X1Y6 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_C.ddr_byte_lane_C/phaser_out}]
#set_property LOC PHASER_OUT_PHY_X1Y5 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_B.ddr_byte_lane_B/phaser_out}]
#set_property LOC PHASER_OUT_PHY_X1Y4 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_A.ddr_byte_lane_A/phaser_out}]
#set_property LOC PHASER_IN_PHY_X1Y4 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_A.ddr_byte_lane_A/phaser_in_gen.phaser_in}]
#set_property LOC OUT_FIFO_X1Y7 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_D.ddr_byte_lane_D/out_fifo}]
#set_property LOC OUT_FIFO_X1Y6 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_C.ddr_byte_lane_C/out_fifo}]
#set_property LOC OUT_FIFO_X1Y5 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_B.ddr_byte_lane_B/out_fifo}]
#set_property LOC OUT_FIFO_X1Y4 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_A.ddr_byte_lane_A/out_fifo}]
#set_property LOC IN_FIFO_X1Y4 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_A.ddr_byte_lane_A/in_fifo_gen.in_fifo}]
#set_property LOC PHY_CONTROL_X1Y1 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/phy_control_i}]
#set_property LOC PHASER_REF_X1Y1 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/phaser_ref_i}]
#set_property LOC OLOGIC_X1Y57 [get_cells  -hier -filter {NAME =~ */ddr_phy_4lanes_0.u_ddr_phy_4lanes/ddr_byte_lane_A.ddr_byte_lane_A/ddr_byte_group_io/*slave_ts}]
#set_property LOC PLLE2_ADV_X1Y1 [get_cells -hier -filter {NAME =~ */u_ddr3_infrastructure/plle2_i}]
#set_property LOC MMCME2_ADV_X1Y1 [get_cells -hier -filter {NAME =~ */u_ddr3_infrastructure/gen_mmcm.mmcm_i}]
          
#set_false_path -through [get_pins -filter {NAME =~ */DQSFOUND} -of [get_cells -hier -filter {REF_NAME == PHASER_IN_PHY}]]
#set_multicycle_path -through [get_pins -filter {NAME =~ */OSERDESRST} -of [get_cells -hier -filter {REF_NAME == PHASER_OUT_PHY}]] -setup 2 -start
#set_multicycle_path -through [get_pins -filter {NAME =~ */OSERDESRST} -of [get_cells -hier -filter {REF_NAME == PHASER_OUT_PHY}]] -hold 1 -start
#set_max_delay -to [get_pins -hier -include_replicated_objects -filter {NAME =~ *temp_mon_enabled.u_tempmon/device_temp_sync_r1_reg[*]/D}] 20
#set_max_delay -from [get_cells -hier *rstdiv0_sync_r1_reg*] -to [get_pins -filter {NAME =~ */RESET} -of [get_cells -hier -filter {REF_NAME == PHY_CONTROL}]] -datapath_only 5
#set_false_path -through [get_nets -hier -filter {NAME =~ */u_iodelay_ctrl/sys_rst_i}]
          
#set_max_delay -datapath_only -from [get_cells -hier -filter {NAME =~ *ddr3_infrastructure/rstdiv0_sync_r1_reg*}] -to [get_cells -hier -filter {NAME =~ *temp_mon_enabled.u_tempmon/xadc_supplied_temperature.rst_r1*}] 20
